/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.region;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.render.region.CuboidRegion;
import org.enginehub.worldeditcui.render.region.CylinderRegion;
import org.enginehub.worldeditcui.render.region.EllipsoidRegion;
import org.enginehub.worldeditcui.render.region.PolygonRegion;
import org.enginehub.worldeditcui.render.region.PolyhedronRegion;
import org.enginehub.worldeditcui.render.region.Region;

public enum RegionType {
    CUBOID("cuboid", "Cuboid", CuboidRegion::new),
    POLYGON("polygon2d", "2D Polygon", PolygonRegion::new),
    ELLIPSOID("ellipsoid", "Ellipsoid", EllipsoidRegion::new),
    CYLINDER("cylinder", "Cylinder", CylinderRegion::new),
    POLYHEDRON("polyhedron", "Polyhedron", PolyhedronRegion::new);

    private static final Map<String, RegionType> BY_NAME;
    private final String key;
    private final String name;
    private final Function<WorldEditCUI, Region> maker;

    private RegionType(String key, String name, Function<WorldEditCUI, Region> maker) {
        this.key = key;
        this.name = name;
        this.maker = maker;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Region make(WorldEditCUI controller) {
        return this.maker.apply(controller);
    }

    public static RegionType named(String key) {
        return BY_NAME.get(key);
    }

    static {
        BY_NAME = new HashMap<String, RegionType>();
        for (RegionType type : RegionType.values()) {
            BY_NAME.put(type.getKey(), type);
        }
    }
}

