/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import org.jetbrains.annotations.Nullable;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private final FabricIconHandler iconHandler = new FabricIconHandler();
    private Double restoreScrollY = null;

    public ModListWidget(class_310 client, int width, int height, int y, int itemHeight, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
            this.restoreScrollY = list.method_44387();
        }
    }

    public void method_44382(double amount) {
        super.method_44382(amount);
        int denominator = Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4));
        if (denominator == 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.method_44387() / (double)Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)));
        }
    }

    public boolean method_25370() {
        return this.parent.method_25399() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.field_22740.method_44713().method_70816((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}));
        }
    }

    public void setSelected(@Nullable ModListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.selectedModId = entry == null ? null : entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
    }

    protected boolean isSelectedEntry(int index) {
        ModListEntry selected = (ModListEntry)this.method_25334();
        ModListEntry entry = this.getEntry(index);
        return selected != null && entry != null && selected.getMod().getId().equals(entry.getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    @Nullable
    public ModListEntry getEntry(int index) {
        if (this.method_25396().size() > index) {
            return (ModListEntry)((Object)this.method_25396().get(index));
        }
        return null;
    }

    protected void removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        super.method_25330((class_350.class_351)entry);
    }

    protected void method_25339() {
        this.setSelected(null);
        this.addedMods.clear();
        super.method_25339();
    }

    protected void remove(int index) {
        ModListEntry entry = (ModListEntry)((Object)this.method_25396().get(index));
        this.addedMods.remove(entry.mod);
        super.method_25330((class_350.class_351)entry);
    }

    public void finalizeInit() {
        this.reloadFilters();
        if (this.restoreScrollY != null) {
            this.method_44382(this.restoreScrollY);
            this.restoreScrollY = null;
        }
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    public void filter(String searchTerm, boolean refresh, boolean reposition) {
        this.method_25339();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            if (ModMenuConfig.CONFIG_MODE.getValue()) {
                return !this.parent.getModHasConfigScreen(mod.getId());
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        for (Mod mod2 : ModSearch.search(this.parent, searchTerm, this.mods)) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (!reposition) {
            return;
        }
        if (this.parent.getSelectedEntry() != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((ModListEntry)this.method_25334()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.method_25396()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.getEntry(0) != null) {
            this.setSelected(this.getEntry(0));
        }
        if (this.method_44387() > (double)Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4))) {
            this.method_44382(Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)));
        }
    }

    protected void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int entryLeft = this.method_25342();
        int entryWidth = this.method_25322();
        int entryHeight = this.field_62109 - 4;
        int entryCount = this.method_25340();
        int x = this.method_46426();
        int y = this.method_46427();
        int yOffset = 2;
        for (int index = 0; index < entryCount; ++index) {
            ModListEntry entry;
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25319(index);
            if (entryBottom < y || entryTop > this.method_55443() || (entry = this.getEntry(index)) == null) continue;
            if (this.isSelectedEntry(index)) {
                int entryContentLeft = entryLeft + entry.getXOffset() - 2;
                int entryContentWidth = entryWidth - entry.getXOffset() + 4;
                this.drawSelectionHighlight(drawContext, entryContentLeft, entryTop + yOffset, entryContentWidth, entryHeight, this.method_25370() ? -1 : -8355712, -16777216);
            }
            entry.setYOffset(yOffset);
            entry.method_25343(drawContext, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    protected void drawSelectionHighlight(class_332 context, int x, int y, int width, int height, int borderColor, int fillColor) {
        context.method_25294(x, y - 2, x + width, y + height + 2, borderColor);
        context.method_25294(x + 1, y - 1, x + width - 1, y + height + 1, fillColor);
    }

    public void ensureVisible(ModListEntry entry) {
        int k;
        int i = this.method_25337(this.method_25396().indexOf((Object)entry));
        int j = i - this.method_46427() - 4 - this.field_62109;
        if (j < 0) {
            this.method_44382(this.method_44387() + (double)j);
        }
        if ((k = this.method_55443() - i - this.field_62109 * 2) < 0) {
            this.method_44382(this.method_44387() - (double)k);
        }
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74234() || input.method_74235()) {
            return super.method_25404(input);
        }
        if (this.method_25334() != null) {
            return ((ModListEntry)this.method_25334()).method_25404(input);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.method_46427())) + (int)this.method_44387() - 4;
        int index = int_5 / this.field_62109;
        return x < (double)this.method_65507() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (ModListEntry)((Object)this.method_25396().get(index)) : null;
    }

    protected int method_65507() {
        return this.field_22758 - 6;
    }

    public int method_25322() {
        return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.method_46426() + 6;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int method_44395() {
        return super.method_44395() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.method_25396()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

